var IE_VER = -1;
function id(idStr)
{
    return document.getElementById(idStr);
}
function el(eleStr)
{
    return document.createElement(eleStr);
}
function setStyle(ele, styles)
{
    if (ele == null || styles == null || ele.nodeType != 1)
    {
        return;
    }

    for (var property in styles)
    {
        try
        {
            ele.style[property] = styles[property];
        }catch(ex){}
    }
}
function getNodeDefaultView(element, cssProperty)
{
    var dv = null;
    if (!(element))
    {
        return null;
    }
    if (element.currentStyle)
    {
        if (cssProperty == "opacity")
        {
            var str = element.currentStyle["filter"];
            if (/opacity=(\S+)/.test(str))
            {
                return (parseFloat(RegExp["$1"]) / 100);
            }
            return 1;
        }
        
        dv = element.currentStyle;
    }
    else
    {
        dv = document.defaultView.getComputedStyle(element, null);
    }
    
    if (cssProperty != undefined && dv)
    {
        return dv[cssProperty];
    }
    else
    {
        return dv;
    }
}
function setOpacity(element, value)
{
    if (IE_VER > 0 && IE_VER < 10)
    {
        element.style.filter = "alpha(opacity=" + (value * 100) + ")" ;
    }
    else
    {
        element.style.opacity = value;
    }
}
function eventPreventDefault(event)
{
    event = event || window.event;
    if(event.preventDefault)
    {
        event.preventDefault();
    }
    else
    {
        event.returnValue = false;
    }
}
function getMousePos(event)
{
    event = event || window.event;
    var doc = document;
    var pos = (event.pageX || event.pageY) ? {x:event.pageX,y:event.pageY}:
            {x:event.clientX + doc.documentElement.scrollLeft - doc.documentElement.clientLeft,
             y:event.clientY + doc.documentElement.scrollTop - doc.documentElement.clientTop};
    return pos;
}
function clearSelection()
{
    window.getSelection ? window.getSelection().removeAllRanges() : document.selection.empty();
}
function getOffset(ele)
{
    var pos = {left: 0, top: 0},
        obj = ele;
    while (obj && obj.offsetParent != obj)
    {
        pos.left += obj.offsetLeft;
        pos.top += obj.offsetTop;
        obj = obj.offsetParent;
    }
    return pos
}
function floatEqual(a, b, precision){
    var tmp = Math.pow(10, precision);
    a = parseInt(a * tmp);
    b = parseInt(b * tmp);
    return (a == b);
}
function NiceScroll(targetId)
{
    this.taId = targetId;
    this.ta = id(this.taId);
    if (this.ta.nodeType != 1)
    {
        return null;
    }
    this.st = el("label");      // scroll tip
    this.sb = el("div");        // scroll bar
    this.sb.timerId = null;
    this.sbH = 0;
    this.scH = 0;
    this.stH = 0;
    this.avg = 0;
    this.sbcH = 0;
    this.n = 20;
    this.enabled = true;
    this.mousePos = null;
    this.isScroll = false;
    this.onSb = false;
    this.show = false;
    this.checkTt = null;
    this.touchDelta = 0;    /* for touch event delta */
    /* Animation Related */
    this.wtId = null;           /* timer id */
    this.wtCounter = 0;         /* timer looping counter */
    this.wSpeed = 0;            /* the distance of scroll bar go every timer function execute */
    this.woSpeed = 0;           /* use to check if scroll back */
    /* endof Related */
    
    if (typeof this.init != "function")
    {
        NiceScroll.prototype.init = function(){
            var obj = this;
            this.sb.id = this.taId + "niceScrollSb" + new Date().getTime();
            
            // this is for the bug of IE6.0~8.0 of mouseover
            setStyle(this.sb, {"backgroundColor":(this.getBgColor() || "white")});
            this.sb.appendChild(this.st);   /* append scrollTip to scrollBar */
            document.body.appendChild(this.sb); /* scroll bar is the child node of body */
            this.reset();

            /* set overflow value of target to hidden */
            setStyle(this.ta, {"overflow":"hidden"});
            this._syncDisplay();
            this._bindEvt();
            
            /* annotation code blow because content of help pages will not change dynamically at this stage */
            /*window.setTimeout(function(){
                obj.checkTt = window.setTimeout(arguments.callee, 1000);
                obj.check();
            }, 100);*/
        };
        NiceScroll.prototype._setSbStyle = function(style){
            if (typeof style == "object")
            {
                setStyle(this.sb, style);
            }
            else
            {
                this.sb.className = style;
            }
        };
        NiceScroll.prototype._setStStyle = function(style){
            if (typeof styleObj == "object")
            {
                setStyle(this.st, styleObj);
            }
            else
            {
                this.st.className = style;
            }
        };
        NiceScroll.prototype.reset = function(){
            var pos = getOffset(this.ta);
            var width = this.ta.offsetWidth;
            var height = this.ta.offsetHeight;
            var sHeight = this.ta.scrollHeight;
            var bdTWidth = parseFloat(getNodeDefaultView(this.ta, "borderTopWidth")) || 0;
            var bdBWidth = parseFloat(getNodeDefaultView(this.ta, "borderBottomWidth")) || 0;
            var bdRWidth = parseFloat(getNodeDefaultView(this.ta, "borderRightWidth")) || 0;
            var bdLWidth = parseFloat(getNodeDefaultView(this.ta, "borderLeftWidth")) || 0;

            this.scH = sHeight - height + bdTWidth + bdBWidth;
            this.stH = parseInt(height / sHeight * height * 0.7);
            this.sbcH = height - (this.stH + 2);
            this.avg = this.scH / this.sbcH;
            if (sHeight - height <= 0)
            {
                setStyle(this.sb, {"visibility":"hidden"});
                this.show = false;
                return;
            }
            else
            {
                setStyle(this.sb, {"visibility":"visible"});
            }

            this.show = true;
            /* set init style of scrollBar */
            setStyle(this.sb, {"top":pos.top + bdTWidth + "px", "left":pos.left + width - bdLWidth - bdRWidth - 7 - 2 + "px", "height":height + "px",
                               "position":"absolute", "zIndex":9002, "width":"7px"});
            /* set init style of scrollTip */
            setStyle(this.st, {"float":"right", "border":"1px solid #C1C9CD", "background":"#DAE0E2",
                               "borderRadius":"3px", "position":"relative", "top":(this.ta.scrollTop/this.scH)*this.sbcH + "px",
                               "width":"5px", "height":this.stH + "px", "display":"inline-block"});
            if (this.isScroll == false)
            {
                this._fadeOut();
            }
        };
        NiceScroll.prototype.getBgColor = function(){
            var bgColor, node = this.ta, result;

            while(true)
            {
                bgColor = getNodeDefaultView(node, "backgroundColor");
                if (bgColor != "transparent")
                {
                    result = bgColor;
                    break;
                }
                if (node.tagName == "body")
                {
                    break;
                }
                node = node.parentNode;
            }
            
            return result;
        };
        NiceScroll.prototype._bindEvt = function(){
            var obj = this;
            if (document.attachEvent)
            {
                this.ta.attachEvent("onmousewheel",  function(event){
                    event = event || window.event;obj.scroll(event)});
                this.sb.attachEvent("onmousewheel",  function(event){
                    event = event || window.event;obj.scroll(event)});
            }
            else
            {
                this.ta.addEventListener("mousewheel",
                    function(event){event = event || window.event;obj.scroll(event)}, false);
                this.ta.addEventListener("DOMMouseScroll",
                    function(event){event = event || window.event;obj.scroll(event)}, false);
                this.sb.addEventListener("mousewheel",
                    function(event){event = event || window.event;obj.scroll(event)}, false);
                this.sb.addEventListener("DOMMouseScroll",
                    function(event){event = event || window.event;obj.scroll(event)}, false);

                try     /* for browser of devices which has touch screen. */
                {
                    this.ta.addEventListener("touchstart", function (event){
                        obj.touchDelta = event.touches[0].pageY;
                    }, false);
                    this.ta.addEventListener("touchmove", function (event){
                        var currPos = event.changedTouches[0].pageY,
                            delta = currPos - obj.touchDelta,
                            result = delta > 0 ? -1 : 1;
                        if (obj.show == true && obj.enabled == true)
                        {
                            obj.scrollShow(event);
                            obj.wheelAnimate(5 * result, 1);
                        }
                        
                        obj.touchDelta = currPos;
                    }, false);
                }catch(ex){/* do nothing */}
            }
            this.st.onmousedown = function(event){
                obj.isScroll = true;
                obj.mousePos = getMousePos(event);
                document.onmouseup = function(event){
                    document.onmousemove = null;
                    document.onmouseup = null;
                    if (this.onSb == false)
                    {
                        obj.isScroll = false;
                    }
                };
                document.onmousemove = function(event){
                    var mousePos = getMousePos(event);
                    var len = mousePos.y - obj.mousePos.y;
                    var top = parseFloat(obj.st.style.top) + len;
                    
                    top = (top >= obj.sbcH?obj.sbcH:(top <= 0?0:top));
                    obj.st.style.top = top + "px";
                    obj.mousePos.y = mousePos.y;
                    obj.ta.scrollTop = obj.scH*(top/obj.sbcH);
                    clearSelection(event);
                };
            };
            /* binding mouse event on scroll bar */
            this.sb.onmouseover = function(event){
                event = event || window.event;
                obj.onSb = true;
                if (obj.show == true)
                {
                    obj.scrollShow(event);
                }
            };
            this.sb.onmouseout = function(){
                obj.onSb = false;
                obj.isScroll = false;
                obj._fadeOut();
            };
        };
        NiceScroll.prototype.close = function(){
            this.sb.style.visibility = "hidden";
            this.enabled = false;
        };
        NiceScroll.prototype.open = function(){
            this.enabled = true;
        };
        NiceScroll.prototype._syncDisplay = function(){
            if (this.ta.style.display == "none" ||
                this.ta.visibility == "hidden")
            {
                this.sb.style.visibility = "hidden";
            }
            else
            {
                this.sb.style.visibility = "visible";
            }
        };
        NiceScroll.prototype.check = function(){
            if (id(this.taId) == null)
            {
                window.clearTimeout(this.checkTt);
                this.sb.parentNode.removeChild(this.sb);
                return;
            }
            if (this.enabled == false)
            {
                return;
            }
            if (this.ta.style.display == "none" ||
                this.ta.visibility == "hidden")
            {
                this.sb.style.visibility = "hidden";
            }
            
            if (parseInt(this.ta.offsetHeight) <= 0)
            {
                this.sb.style.visibility = "hidden";
            }
            this.reset();
        };
        NiceScroll.prototype._getWheelDelta = function(event){
            event = event || window.event;
            if (event.wheelDelta)
            {
                return window.opera && window.opera.version < 9.5 ? -event.wheelDelta : event.wheelDelta;
            }
            else
            {
                return -event.detail * 40;
            }
        };
        NiceScroll.prototype.wheelAnimate = function(speed, counter){
            var obj = this, oppsite = false;
            if (this.wtId)  /* continue triggering */
            {
                oppsite = (this.woSpeed ^ speed) < 0;
                this.wtCounter = oppsite ? counter : (this.wtCounter + counter < 50 ? this.wtCounter + counter : 50);
                this.wSpeed = oppsite ? speed : this.wSpeed * 1.05;     /* speed up */
                return;
            }
            
            this.wtCounter = counter;
            this.woSpeed = this.wSpeed = speed;
            (function()
            {
                var temp = 0;
                
                obj.wtId = window.setTimeout(arguments.callee, 5);
                if (obj.wtCounter < 0)
                {
                    clearTimeout(obj.wtId);
                    obj.wtId = null;
                    if (obj.onSb == false)
                    {
                        obj.isScroll = false;
                    }
                    obj._fadeOut();
                    return;
                }
                var newTop = parseFloat(obj.ta.scrollTop) + parseInt(obj.wSpeed);
                if (newTop >= obj.scH || newTop <= 0)
                {
                    obj.wtCounter = 0;
                }
                obj.ta.scrollTop = newTop;
                temp = (obj.ta.scrollTop/obj.scH)*obj.sbcH;
                if (!isNaN(temp))
                {
                    obj.st.style.top = temp + "px"; /* synchronized scroll bar */
                }
                obj.wtCounter--;
            })();
        };
        NiceScroll.prototype.scrollShow = function(event){
            window.clearTimeout(this.sb.timerId);
            this.sb.style.visibility = "visible";
            setOpacity(this.sb, 1);
            this.isScroll = true;
            eventPreventDefault(event);
        };
        NiceScroll.prototype.scroll = function(event){
            event = event || window.event;
            var delta = this._getWheelDelta(event);
            var result = delta > 0 ? -1 : 1;
            
            if (this.show == true && this.enabled == true)
            {
                this.scrollShow(event);
                this.wheelAnimate(5 * result, 7);
            }
        };
        NiceScroll.prototype.fadeTo = function (time, value){
            var currOpacity = parseFloat(getNodeDefaultView(this.sb, "opacity")),
                finalOpacity = value > 1 ? value / 100 : value,
                distance = finalOpacity - currOpacity,
                ti = 100, speed = distance / time * ti, sb = this.sb;
            
            this.sb.timerId = window.setTimeout(function (){
                currOpacity += speed;
                setOpacity(sb, currOpacity);
                if (speed > 0 && currOpacity < finalOpacity ||
                    speed < 0 && currOpacity > finalOpacity)
                {
                    sb.timerId = window.setTimeout(arguments.callee, ti);
                }
                else
                {
                    setOpacity(sb, finalOpacity);
                }
            }, ti);
        };
        NiceScroll.prototype._fadeOut = function (){
            this.fadeTo(1000, 0.6);
        };
    }
}

function helpLoad()
{
    var contentHeight = 600;
    try{contentHeight = window.parent.getCurrentHeight() - 70;}catch(ex){}
    var html = "<div id=\"content\" style=\"height: " + contentHeight + "px;overflow: hidden\">" + document.body.innerHTML + "</div>";
    document.body.innerHTML = html;
    
    window.parent.helpPageTemporaryShow(function (){
        var niceScroll = new NiceScroll("content");
        niceScroll.init();
        niceScroll.open();
    }, window);
}

(function (){
    var ua = navigator.userAgent;
    if (/MSIE ([^;]+)/.test(ua))
    {
        IE_VER = parseFloat(RegExp["$1"]);
    }
    window.onload = helpLoad;
})();